(* caLayer.ml     Wrapper for Cocoa Touch CALayer
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 *)
open Cocoa

external _masksToBounds : nativeint -> bool =
    "CALayer_masksToBounds"
external _setMasksToBounds_ : nativeint -> bool -> unit =
    "CALayer_setMasksToBounds_"
external _cornerRadius : nativeint -> float =
    "CALayer_cornerRadius"
external _setCornerRadius_ : nativeint -> float -> unit =
    "CALayer_setCornerRadius_"
external _borderWidth : nativeint -> float =
    "CALayer_borderWidth"
external _setBorderWidth_ : nativeint -> float -> unit =
    "CALayer_setBorderWidth_"
external _borderColor : nativeint -> color =
    "CALayer_borderColor"
external _setBorderColor_ : nativeint -> color -> unit =
    "CALayer_setBorderColor_"

class t robjcv =
    object (self)
    inherit Wrapper.t robjcv

    method masksToBounds = _masksToBounds self#contents
    method setMasksToBounds' b = _setMasksToBounds_ self#contents b
    method cornerRadius = _cornerRadius self#contents
    method setCornerRadius' f = _setCornerRadius_ self#contents f
    method borderWidth = _borderWidth self#contents
    method setBorderWidth' f = _setBorderWidth_ self#contents f
    method borderColor = _borderColor self#contents
    method setBorderColor' color = _setBorderColor_ self#contents color
    end

let () = Callback.register "CaLayer.wrap" (new t)
