(* nsTimer.ml     Wrapper for Cocoa Touch NSTimer
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 *)

class t robjcv =
    object (self)
    inherit Wrapper.t robjcv
    end

let () = Callback.register "NsTimer.wrap" (new t)

external _scheduledTimer5 :
    float -> #Wrappee.t -> string -> #Wrappee.t -> bool -> t =
        "NSTimer_scheduledTimer5"

let scheduledTimerWithTimeInterval'target'selector'userInfo'repeats' =
        _scheduledTimer5

let scheduledTimer5 =
    (* Shorter form.
     *)
    scheduledTimerWithTimeInterval'target'selector'userInfo'repeats'
