(* slide24AppDelegate.ml     Application delegate for Slide24
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 *)

class t =
object (self)
    inherit Wrappee.t

    val mutable theWindow: UiWindow.t option = None
    val mutable theVCD: Ui.slide24ViewControllerD option = None

    method window =
        match theWindow with
        | None -> UiWindow.nil
        | Some window -> window

    method setWindow' window =
        theWindow <- Some window

    method applicationDidFinishLaunching' (app: Ui.application) =
        let rvc = self#window#rootViewController in
        let vcd = rvc#delegate in
        theVCD <- Some vcd;
        vcd#launchWithView rvc#view

    method applicationDidReceiveMemoryWarning' (appl: Ui.application) =
        Gc.compact ()  (* Best effort to reclaim space *)

    method applicationWillResignActive' (appl: Ui.application) =
        match theVCD with
        | None -> ()
        | Some vcd -> vcd#deactivate

    method applicationDidBecomeActive' (appl: Ui.application) =
        match theVCD with
        | None -> ()
        | Some vcd -> vcd#activate
end

let () =
    let wrapped robjcv = let t = new t in t#setContainer robjcv; t in
    Callback.register "Slide24AppDelegate.wrapped" wrapped
