(* slide24ViewController.ml     Wrapper for Slide24 view controller
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 *)

external _delegate : nativeint -> Slide24ViewControllerD.t =
    "Slide24ViewController_delegate"
external _setDelegate_ : nativeint -> Slide24ViewControllerD.t -> unit =
    "Slide24ViewController_setDelegate_"
external _view : nativeint -> UiView.t =
    "Slide24ViewController_view"

class t robjcv =
object (self)
    inherit Wrapper.t robjcv

    method delegate = _delegate self#contents
    method setDelegate' d = _setDelegate_ self#contents d
    method view = _view self#contents
end

let () = Callback.register "Slide24ViewController.wrap" (new t)

