(* slide24defs.ml     Common definitions for Slide24 example
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 *)

let frnd f =
    floor (f +. 0.5)

let rec last l =
    match l with
    | [] -> invalid_arg "last of []"
    | [b] -> b
    | _ :: rest -> last rest

let rec take n l =
    if n <= 0 then
        []
    else
        match l with
        | [] -> []
        | h :: t -> h :: take (n - 1) t

let rec range i j =
    if i > j then [] else i :: range (i + 1) j

let rec drange i j =
    if i < j then [] else i :: drange (i - 1) j

let udrange i j =
    if i <= j then range i j else drange i j

let array_findi p arr =
    let n = Array.length arr in
    let rec loop i =
        if i = n then raise Not_found
        else if p arr.(i) then i
        else loop (i + 1)
    in
    loop 0

(* Timer tick period (seconds).
 *)
let interval = 0.5

(* A configuration of tiles is represented by an array A containing a
 * permutation of 0..24, with 0 representing the empty spot.  A.(0)
 * tells which tile is at the upper left, A.(1) is the tile just to the
 * right of this.
 *)
type config = int array
