(* ui.mli     Some base types from UIKit
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 *)

(* (For simplicity, these view controller types are specialized for
 * Slide24.)
 *)

class type
    slide24ViewControllerD =
        object
        inherit Wrappee.t
        method shuffle : UiButton.t
        method setShuffle' : UiButton.t -> unit
        method solve : UiButton.t
        method setSolve' : UiButton.t -> unit
        method launchWithView : UiView.t -> unit
        method activate : unit
        method deactivate : unit
        method doShuffle' : UiButton.t -> unit
        method doSolve' : UiButton.t -> unit
        method runsolve : unit
        method timerTick' : NsTimer.t -> unit
        method viewController'viewWillAppear' :
            slide24ViewController -> bool -> unit
        method viewController'viewWillDisappear' :
            slide24ViewController -> bool -> unit
        method viewControllerShouldAutorotate' :
            slide24ViewController -> bool
        method touchTile' : UiButton.t -> unit
        end

and
    slide24ViewController =
        object
        inherit Wrapper.t
        method delegate : slide24ViewControllerD
        method setDelegate' : slide24ViewControllerD -> unit
        method view : UiView.t
        end

class type
    window =
        object
        inherit Wrapper.t
        method rootViewController : slide24ViewController
        end

class type
    application =
        object
        inherit Wrapper.t
        method delegate : applicationDelegate
        end

and 
    applicationDelegate =
        object
        inherit Wrappee.t
        method window : window
        method setWindow' : window -> unit
        method applicationDidFinishLaunching' : application -> unit
        method applicationWillResignActive' : application -> unit
        method applicationDidBecomeActive' : application -> unit
        method applicationDidReceiveMemoryWarning' : application -> unit
        end
