(* uiButton.mli     Wrapper for Cocoa Touch UIButton
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 *)
open Cocoa

type buttonType =
    TypeCustom | TypeRoundedRect | TypeDetaileDisclosure | TypeInfoLight |
    TypeInfoDark | TypeContactAdd

(* A set of events is represented as a list.  We just define the touch
 * events
 *)
type controlEvent = 
   EventTouchDown | EventTouchDownRepeat | EventTouchDragInside |
   EventTouchDragOutside | EventTouchDragEnter | EventTouchDragExit |
   EventTouchUpInside | EventTouchUpOutside | EventTouchCancel
type controlEvents = controlEvent list

(* What the API calls a state is closer to a set of states, again
 * represented as a list.
 *)
type controlState = StateHighlighted | StateDisabled | StateSelected
type controlStates = controlState list
val kStateNormal : controlStates

class t : nativeint ->
    object
    (* inherit Wrapper.t *)
    inherit UiView.t

    method layer : CaLayer.t

    method frame : rect
    method setFrame' : rect -> unit

    method addTarget'action'forControlEvents' :
        #Wrappee.t -> string -> controlEvents -> unit

    method enabled : bool
    method setEnabled' : bool -> unit

    method setTitle'forState' : string -> controlStates -> unit
    method setTitleColor'forState' : color -> controlStates -> unit
    method titleColorforState' : controlStates -> color
    method titleForState' : controlStates -> string
    method titleSize : float
    method setTitleSize' : float -> unit

    method setBackgroundImage'forState' : image -> controlStates -> unit

    method currentTitle : string
    method currentTitleColor : color
    end

val buttonWithType' : buttonType -> t
