(* uiView.ml     Wrapper for Cocoa Touch UIView
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 *)

external _frame : nativeint -> Cocoa.rect = "UIView_frame"
external _addSubview_ : nativeint -> nativeint -> unit = "UIView_addSubview_"

class t robjcv =
    object (self)
    inherit Wrapper.t robjcv

    method frame =
        _frame self#contents
    method addSubview' (sv: t) =
        _addSubview_ self#contents sv#contents
    end

let () = Callback.register "UiView.wrap" (new t)

external beginAnimations'context' : string -> int -> unit =
    "UIView_beginAnimations_context_"

external commitAnimations : unit -> unit =
    "UIView_commitAnimations"

external setAnimationDuration' : float -> unit =
    "UIView_setAnimationDuration_"
