/* wrap.h     Simple custom wrappers for Slide24 example
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 */
#import "caml/mlvalues.h"

/* An OCaml value wrapped up for access from ObjC.
 */
@interface WrapOCaml : NSObject
@property (nonatomic, readonly) value contents;
@end
    
/* A protocol for delegation of view controller behavior.
 */
@protocol ViewControllerDelegate
- (void) viewController: (UIViewController *) vc
         viewWillAppear: (BOOL) animated;
- (void) viewController: (UIViewController *) vc
         viewWillDisappear: (BOOL) animated;
- (BOOL) viewControllerShouldAutorotate: (UIViewController *) vc;
@end


/* Wrapped version of Slide24AppDelegate.t
 */
@interface Slide24AppDelegate : WrapOCaml <UIApplicationDelegate>
@end

/* Wrapped version of Slide24ViewControllerD.t
 */
@interface Slide24ViewControllerD : WrapOCaml <ViewControllerDelegate>
@property (nonatomic, strong) IBOutlet UIButton *shuffle;
@property (nonatomic, strong) IBOutlet UIButton *solve;
- (void) timerTick: (NSTimer *) aTimer;
- (IBAction) doShuffle: (UIButton *) button;
- (IBAction) doSolve: (UIButton *) button;
- (void) runsolve;
@end

/* Slide24ViewController just passes methods along to a delegate.
 */
@interface Slide24ViewController : UIViewController
@property (nonatomic, strong) IBOutlet id<ViewControllerDelegate> delegate;
@end
