(* wrappee.ml     OCaml objects that are wrapped inside ObjC objects
 *
 * Copyright (c) 2015 Psellos   http://psellos.com
 *
 * Licensed under the MIT license:
 *     http://www.opensource.org/licenses/mit-license.php
 *)

external _performSelector_withDelay_ : nativeint -> string -> float -> unit =
    "Wrappee_performSelector_withDelay_"

class t =
    (* Subclasses of this class are wrapped inside ObjC objects.
     *)
    object
        val mutable container: nativeint = 0n (* 0n -> no wrapper *)
        method container = container
        method setContainer robjcv = container <- robjcv
        method performSelector'withDelay' sel secs =
            _performSelector_withDelay_ container sel secs
    end

let nil = new t (* Unwraps as nil in ObjC *)
